/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
* Copyright 2016 Adobe Systems Incorporated
* All Rights Reserved.
*
* NOTICE: All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any. The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
/*jslint node: true, vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50, unparam: true */
/*global define, module, require, moment, console, ArrayBuffer, Uint8Array, window, XMLHttpRequest */

/**
 * The main entry point for the Ingest API. This module is exported
 * as a requireJS module, or can be included in a node.js environment
 * with `require('/path/to/main.js')`.
 *
 * @namespace Ingest
 */

// Support either node.js or in the browser
/* istanbul ignore else */
if (typeof define !== 'function') { var define = require('amdefine')(module); }

define(function (require, exports, module) {
    'use strict';

    var Ingest = require('./Ingest');

    // Export public API
    var IngestAPI = {};

    /**
     * Create an instance of the Ingest API
     *
     * @param {Object} dependencies
     *     External services that the API depends on.
     * @param {Function} [dependencies.log]
     *     A function that we will call with a single string parameter whenever we have something to log. Provide this if you want to get log
     *     messages from the API, e.g. to log them to a file, or print in the console.
     * @param {Function} [dependencies.getAccessToken]
     *     A function that we get access token
     * @param {Function} [dependencies.clearAccessToken]
     *     A function that we use to clear your cached access token when access token is expired
     * @param {Function} [dependencies.getAgent]
     *     A function that we get agent to make nodejs https request.
     * @param {Object} options
     *     Options to set for the Ingest API.
     * @param {String} [options.ENVIRONMENT=prod]
     *     The environment to use - either 'prod', 'stage', or 'dev'. Default is production.
     * @param {String} [options.ANALYTICS_INGEST_TYPE=dunamis]
     *     The ingest type - if you're not sure what this is, you probably shouldn't change it.
     * @param {Number} [options.ANALYTICS_MAX_QUEUED_EVENT=50]
     *     Maximum number of events to queue if offline (if we queue more than this, the oldest get thrown away).
     * @param {Number} [options.ANALYTICS_DEBOUNCE=10000]
     *     Minimum time between sending analytics in milliseconds (events are batched up and sent no more frequently that this).
     * @param {String} options.ANALYTICS_API_KEY
     *     Your client id - this must match the access tokens you provide. Required.
     * @param {String} options.ANALYTICS_X_PRODUCT
     *     String describing the main product/application. Required.
     * @param {String} [options.ANALYTICS_X_PRODUCT_LOCATION]
     *     String describing a component in the product - e.g. if you're a panel/extension inside another product, this would be used.
     * @param {String} options.ANALYTICS_PROJECT
     *     Project name in the analytics backend. Required.
     * @param {String} [options.ANALYTICS_USER_REGION=UNKNOWN]
     *     Region identifier (x-user-region header).
     * @param {String} [options.TIMESTAMP_PROPERTY_NAME=event.dts_end]
     *     Name to use for the timestamp property. You should ONLY set this as a backward compatibility measure if you're not using the
     *     standard data model.
     * @memberof IngestAPI
     */
    IngestAPI.createInstance = function (dependencies, options) {
        return new Ingest(dependencies, options);
    };

    return IngestAPI;
});
